/* xxxerfc.h -- common _[FL]Erfc functionality */
#include "xmath.h"
_STD_BEGIN

	/* coefficients */

 #if   FBITS <= 24
  #define DPOLY(x)	((c[0] * x + c[1]) * x + c[2])
  #define NPOLY(x)	(((s[0] * x + s[1]) * x + s[2]) * x + s[3])

/* extern const */ FTYPE FNAME(Erf_one) = FLIT(3.82);

static const FTYPE s[] = {	/* 3/2, 1.523 <= x <= 3.82 */
	FLIT(-0.1904329681e-3),
	FLIT( 0.3365143039e-2),
	FLIT( 0.3904994244),
	FLIT( 0.8272613270),
	};

static const FTYPE c[] = {
	FLIT( 0.7372748054),
	FLIT( 1.2764107769),
	FLIT( 0.8419510227),
	};

 #elif FBITS <= 53
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

/* extern const */ FTYPE FNAME(Erf_one) = FLIT(5.84);

static const FTYPE s[] = {	/* 6/6, 1.523 <= x <= 5.84 */
	FLIT( 0.61792832735846070258e-9),
	FLIT( 0.11684287172270874217e-1),
	FLIT( 0.95637893500953094717e-1),
	FLIT( 0.38676415143622898851),
	FLIT( 0.91231706220035757904),
	FLIT( 1.25253625614956703876),
	FLIT( 0.83571382001120956678),
	};

static const FTYPE c[] = {
	FLIT( 0.20709916302643547030e-1),
	FLIT( 0.16951239053544544290),
	FLIT( 0.69589694980162046232),
	FLIT( 1.70158409934440707405),
	FLIT( 2.55410155085533580188),
	FLIT( 2.19550662597046521735),
	FLIT( 0.83571864525686785467),
	};

 #elif FBITS <= 67
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

/* extern const */ FTYPE FNAME(Erf_one) = FLIT(6.45);

static const FTYPE s[] = {	/* 8/8, 1.523 <= x <= 6.45 */
	FLIT( 0.3982366595670504399244521e-12),
	FLIT( 0.1030575181954501302353221e-2),
	FLIT( 0.1324015678034616536851924e-1),
	FLIT( 0.8468413085000757161966266e-1),
	FLIT( 0.3372142827713188129837938),
	FLIT( 0.8925819419479200421116839),
	FLIT( 1.5680950663872533819280129),
	FLIT( 1.7077875378129038467960200),
	FLIT( 0.9172727087211874336366180),
	};

static const FTYPE c[] = {
	FLIT( 0.1826647001857809893554410e-2),
	FLIT( 0.2346756505420102427184070e-1),
	FLIT( 0.1510120775753143340433125),
	FLIT( 0.6094299039184962013668769),
	FLIT( 1.6562038680390530271358464),
	FLIT( 3.0664204964536552860192478),
	FLIT( 3.7457634749394795507231292),
	FLIT( 2.7428186078612249378422898),
	FLIT( 0.9172727509137699498745190),
	};

 #elif FBITS <= 113
  #define DPOLY(x)	FNAME(Poly)(x, c, sizeof (c) / sizeof (c[0]) - 1)
  #define NPOLY(x)	FNAME(Poly)(x, s, sizeof (s) / sizeof (s[0]) - 1)

/* extern const */ FTYPE FNAME(Erf_one) = FLIT(8.68);

static const FTYPE s[] = {	/* 16/15, 1.523 <= x <= 8.68 */
	FLIT( 0.48855209310640276804305233185598921e-26),
	FLIT(-0.88227359218857478559335144433937656e-24),
	FLIT( 0.55461604037503267563215470701218812e-8),
	FLIT( 0.19014277865124507488158812474886923e-6),
	FLIT( 0.32520972668934791576950783450350765e-5),
	FLIT( 0.36388642487576878259051891057073040e-4),
	FLIT( 0.29557014465679734454153740538111773e-3),
	FLIT( 0.18351323952331700907225852099564597e-2),
	FLIT( 0.89534212346402258584503055479788071e-2),
	FLIT( 0.34801798915914533366900587811088718e-1),
	FLIT( 0.10819185350486092639853054900511446),
	FLIT( 0.26770678673921654105352596126503848),
	FLIT( 0.51957496897602199640258780829689114),
	FLIT( 0.76893852075313785542678534369981692),
	FLIT( 0.82392646495986814492858615912585115),
	FLIT( 0.57636263867860456048919433777939797),
	FLIT( 0.20108119985903088508219012350654573),
	};

static const FTYPE c[] = {
	FLIT( 0.98303133653668207579238433353825957e-8),
	FLIT( 0.33701930024228231587253433671219488e-6),
	FLIT( 0.57691074809070078550876764981535688e-5),
	FLIT( 0.64665699156461426447612497779078724e-4),
	FLIT( 0.52676162211479305928855854637498930e-3),
	FLIT( 0.32847675659616013862588770587625771e-2),
	FLIT( 0.16128598358289219076328461990453505e-1),
	FLIT( 0.63279098928549700456425105853399327e-1),
	FLIT( 0.19944504788391965783604607553960587),
	FLIT( 0.50379293566266091223169156435954456),
	FLIT( 1.00949883502072169922224925756156511),
	FLIT( 1.57308974099935961959954265933666554),
	FLIT( 1.84249001357607014096332750744848032),
	FLIT( 1.52922539464127030194091217994490513),
	FLIT( 0.80325847549410657269231276509661127),
	FLIT( 0.20108119985903069604991623646723121),
	};

 #else /* FBITS */
  #error _Erfc has insufficient precision
 #endif /* FBITS */

/* extern const */ FTYPE FNAME(Erf_small) = FLIT(1.523);

FTYPE (FNAME(Erfc))(FTYPE x)
	{	/* compute erfc(x), 1 - 2^(FBITS-1/2) < erfc(x) < 1/2 */
	FTYPE z = -x * x;

	FNAME(Exp)(&z, NPOLY(x) / DPOLY(x), 0);
	return (z);
	}
_STD_END

/*
 * Copyright (c) 1992-2003 by P.J. Plauger.  ALL RIGHTS RESERVED.
 * Consult your license regarding permissions and restrictions.
V4.02:1422 */
